package javabasico.io;

import java.io.*;

/**
 * Um PromptingReader que no retorna exceo (para principiantes).
 *
 * @see	  p1.io.PromptingReader
 *
 * @author   Jacques Philippe Sauv, jacques@dsc.ufpb.br
 * @version 1.1
 * <br>
 * Copyright (C) 1999 Universidade Federal da Paraba.
 */
public class PromptingReaderSemExcecao extends PromptingReader {

	public PromptingReaderSemExcecao(Reader in) {
		super(in);
	}

	/**
	 * L uma linha da entrada padro. No lana exceo.
	 * @return A linha lida.
	 */
	public String lerLinha() {
		try {
			return super.lerLinha();
		} catch(IOException e) {
			return null;
		}
	}

	/**
	 * L uma linha da entrada padro. No lana exceo. D um prompt para o usurio.
	 * @return A linha lida. Retorna null no fim da entrada.
	 */
	public String lerLinha(String prompt) {
	  	printPrompt(prompt);
		return lerLinha();
	}

	/**
	 * L uma palavra da entrada padro. No lana exceo.
	 * @return A palavra lida. Retorna null no fim da entrada.
	 */
	public String lerPalavra() {
		try {
			return super.lerPalavra();
		} catch(IOException e) {
			return null;
		}
	}

	/**
	 * L uma palavra da entrada padro. No lana exceo. D um prompt para o usurio.
	 * @return A palavra lida. Retorna null no fim da entrada.
	 */
	public String lerPalavra(String prompt) {
	  	printPrompt(prompt);
		return lerPalavra();
	}

	/**
	 * L um inteiro da entrada padro. No lana exceo.
	 * @return O inteiro lido, como objeto Integer. Retorna null no fim da entrada.
	 */
	public Integer lerInteiro() {
		while(true) {
				try {
				return super.lerInteiro();
			} catch(IOException e) {
				return null;
			} catch(NumberFormatException e) {
				System.out.println("Nao eh um numero inteiro. Tente novamente.");
			}
		}
	}

	/**
	 * L um inteiro da entrada padro. No lana exceo. D um prompt para o usurio.
	 * @return O inteiro lido, como objeto Integer. Retorna null no fim da entrada.
	 */
	public Integer lerInteiro(String prompt) {
	  	printPrompt(prompt);
		return lerInteiro();
	}

	/**
	 * L um inteiro da entrada padro. No lana exceo.
	 * @return O inteiro lido, como int. No indica fim de entrada.
	 */
	public int lerInt() {
        Integer i = lerInteiro();
        return i == null ? 0 : i.intValue();
    }

	/**
	 * L um inteiro da entrada padro. No lana exceo.  D um prompt para o usurio.
	 * @return O inteiro lido, como int. No indica fim de entrada.
	 */
	public int lerInt(String prompt) {
        Integer i = lerInteiro(prompt);
        return i == null ? 0 : i.intValue();
    }

	/**
	 * L um nmero real da entrada padro. No lana exceo.
	 * @return O nmero lido, como objeto Double. Retorna null no fim da entrada.
	 */
	public Double lerDouble() {
		while(true) {
				try {
				return super.lerDouble();
			} catch(IOException e) {
				return null;
			} catch(NumberFormatException e) {
				System.out.println("Nao eh um numero real. Tente novamente.");
			}
		}
	}

	/**
	 * L um nmero real da entrada padro. No lana exceo. D um prompt para o usurio.
	 * @return O nmero lido, como objeto Double. Retorna null no fim da entrada.
	 */
	public Double lerDouble(String prompt) {
	  	printPrompt(prompt);
		return lerDouble();
	}

	/**
	 * L um nmero real da entrada padro. No lana exceo.
	 * @return O nmero lido, como double. No indica fim da entrada.
	 */
	public double lerdouble() {
		while(true) {
				try {
				return super.lerDouble().doubleValue();
			} catch(IOException e) {
				return 0.0;
			} catch(NumberFormatException e) {
				System.out.println("Nao eh um numero real. Tente novamente.");
			}
		}
	}

	/**
	 * L um nmero real da entrada padro. No lana exceo. D um prompt para o usurio.
	 * @return O nmero lido, como double. No indica fim da entrada.
	 */
	public double lerdouble(String prompt) {
	  	printPrompt(prompt);
		return lerdouble();
	}

	/**
	 * L um caractere da entrada padro. No lana exceo.
	 * @return O caractere lido. Retorna -1 no fim da entrada.
	 */
	public int read() {
		try {
			return super.read();
		} catch(IOException e) {
			// vai retornar lixo (MAX_VALUE), mas esta classe 
			// para principiantes ate que eles usem excees
			// Talvez o MAX_VALUE faa o programa pipocar ...
			return Integer.MAX_VALUE;
		}
	}

	/**
	 * L um caractere da entrada padro. No lana exceo. D um prompt para o usurio.
	 * @return O caractere lido. Retorna -1 no fim da entrada.
	 */
	public int read(String prompt) {
  		printPrompt(prompt);
		return read();
	}

    /* falta converter os testes para JUNIT */
	public void testar() {
		try {
			super.testar();
		} catch(IOException e) {}	// Nao deve ter excecao devido ao override das funcoes acima
									// o try-catch  s para satisfazer o compilador
	}
}
