package javabasico.io;

import java.io.*;

/**
 * Uma classe utilitria para entrada e sada padro.
 * Contm streams estticos in, out, err
 * Foi criado para que "in" fosse un Reader e no um InputStream
 * porque InputStream no tem um metodo readLine().
 * Tambm se queria uma soluo em portugus para os alunos principiantes
 * entenderem que isso <I>no</I>  Java comum.
 * Os streams out e err foram adicionados para manter a uniformidade.<p>
 *
 * @author   Jacques Philippe Sauv, jacques@dsc.ufpb.br
 * @version 1.1
 * <br>
 * Copyright (C) 1999 Universidade Federal da Paraba.
 */

public class Console {
	/** Um Reader que permite chamar readLine() da entrada padro */
	public static final PromptingReader in = new PromptingReader(new InputStreamReader(System.in));
	/** Um Writer para a sada padro */
	public static final PrintWriter out = new PrintWriter(System.out, true); // com autoflush de println()
	/** Um Writer para a sada padro de erros */
	public static final PrintWriter err = new PrintWriter(System.err, true);

	public static void main(String[] args) {
		try {
			in.testar();
		} catch(Exception e) {
			err.println(e);
		}
	}
}
