package com.gugawag.bancos.gui;

import com.gugawag.bancos.Apolice;
import com.gugawag.bancos.BancoInvest;
import com.gugawag.bancos.BancoSeguros;
import com.gugawag.bancos.Poupanca;
import com.gugawag.bancos.auditoria.AuditorBI;
import com.gugawag.bancos.auditoria.AuditorBS;

public class AppAuditoria {
	public static void main(String[] args) {
		BancoInvest itau = new BancoInvest();
		itau.inserir(new Poupanca("1", 100));
		itau.inserir(new Poupanca("2", 20000));

		BancoSeguros seguroSA = new BancoSeguros();
		seguroSA.inserir(new Apolice("1", 400));
		seguroSA.inserir(new Apolice("2", 300));

		//Auditoria

		AuditorBI auditorBI = new AuditorBI();
		AuditorBS auditorBS = new AuditorBS();

		System.out.println("Resultado auditoria Banco de Investimento: " + auditorBI.investigaBanco(itau));
		System.out.println("Resultado auditoria Banco de Seguros: " + auditorBS.investigaBanco(seguroSA));

		//Tente criar um novo tipo de banco, tipo BancoComun, e tente ver a quantidade de cdigo que voc
		// precisar fazer. No mnimo, precisar criar mais um tipo de auditor: AuditorBancoComum! :(

	}

}
