package com.gugawag.bancos;

import java.util.ArrayList;
import java.util.List;

public class BancoInvest {
	private List<Poupanca> poupancas;

	public BancoInvest(){
		poupancas = new ArrayList<Poupanca>();
	}

	//Mtodos que importam para o problema
	public int numPoupancas(){
		return poupancas.size();
	}

	public double saldoTotal(){
		double saldoTotal = 0;
		for (Poupanca poupanca : poupancas) {
			saldoTotal += poupanca.getSaldo();
		}
		return saldoTotal;
	}
	//Fim mtodos que importam para o problema

	public void inserir(Poupanca poupanca){
		poupancas.add(poupanca);
	}

	public Poupanca procurar(String numero){
		for (Poupanca poupanca : poupancas) {
			if (numero.equals(poupanca.getNumero())){
				return poupanca;
			}
		}
		return null;
	}

	//...
}