package org.fatec.banco.negocio;


import org.fatec.banco.dados.RepositorioClientesArray;
import org.fatec.banco.dados.RepositorioContasArray;

public class FachadaBanco {
	
	private RepositorioContasArray repContas;
	private RepositorioClientesArray repClientes;
	
	public FachadaBanco(){
		repContas = new RepositorioContasArray();
		repClientes = new RepositorioClientesArray();
	}
	
	
	public boolean inserirConta( Conta conta, String cpf ){
		Cliente cliente = repClientes.procurar(cpf);
		if ( cliente != null ){
			conta.setTitular( cliente );
			repContas.inserir(conta);
			return true;
		}
		return false;
	}
	
	/**
	 * Creditar saldo:
	 * @param Metodo que credita um valor ao saldo da conta.
	 * 
	 */
	public boolean creditar(String numeroConta, double valor){		
		Conta conta = repContas.procurar(numeroConta);
		if(conta != null){
			conta.creditar(valor);
			return true;
		}
		return false;
	}

	/**
	 * Debitar saldo:
	 * @param Metodo que vai debitar o valor pedido em uma conta
	 * @return -1, se o saldo atual for ficar negativo. 0 se foi debitado com sucesso()
	 *         -2, se a conta np existe.
	 */
	public int debitar(String numeroConta, double valor){		
		Conta conta = repContas.procurar(numeroConta);
		double saldoAtual = conta.getSaldo();
		if (saldoAtual < valor){
			return -1;
		}		
		if(conta != null){
			conta.debitar(valor);
			return 0;
		}
		return -2;		
	}
	
	public void transferir( String numeroContaOrigem, String numeroContaDestino, double valor ){
		
	}
	
	/**
	 * 
	 * @param nome
	 * @param cpf
	 * @return -1, se banco estiver cheio. -2 se cliente j existe, 0 se inserido com sucesso.
	 */
	public int inserirCliente( String nome, String cpf ){
		if (repClientes.cheio()){
			return -1;
		}		
		Cliente cliente = repClientes.procurar(cpf);
		if (cliente != null){
			return -2;
		}
		
		Cliente clienteAInserir = new Cliente( nome, cpf );
		repClientes.inserir(clienteAInserir);
		return 0;		
	}
	
	
	
	
	
	
	
	
	
	
	
	

}