package org.fatec.banco.dados;

import java.util.Iterator;
import java.util.Vector;

import org.fatec.banco.negocio.Cliente;

public class RepositorioClientesArray {
	private Cliente[] clientes;
	
	public RepositorioClientesArray(){
		clientes = new Cliente[2];
	}
	
	public boolean cheio(){
		return (proximaPosicaoLivre() == -1);
	}
	
	public void inserir( Cliente cliente ){
		int posicaoLivre = proximaPosicaoLivre();
		
		if (!cheio()){
			clientes[posicaoLivre] = cliente;
		}
		
	}
	
	private int proximaPosicaoLivre() {
		
		for (int i = 0; i < clientes.length; i++){
			if ( clientes[i] == null ){
				return i;
			}
		}		
		return -1;
	}

	public void remover( String cpf ){
		for (int i = 0; i < clientes.length; i++) {
			if (cpf.equals( clientes[i].getCpf() )){
				clientes[i] = null;
			}
		}		
	}
	
	public Cliente procurar( String cpf ){		
		for (Cliente cliente : clientes) {
			if ( cliente != null && cpf.equals(cliente.getCpf()) ){
				return cliente;
			}
		}		
		return null;		
	}
	
	public void alterar( Cliente cliente ){
		Cliente clienteAtual = procurar(cliente.getCpf());
		clienteAtual.setNome( cliente.getNome() );
	}

}
