package org.fatec.banco.negocio;

public class Conta {

	/**
	 * Atributos da classe
	 */
	private String numeroConta;
	private double saldo;
	private Cliente titular; 
	
	/**
	 * Numero statico que gera o numero da conta
	 */
	private static int proximoNum = 1;

	public Conta(double saldo){
		this(saldo, null);
	}
	
	/**
	 *Construtor da classe Conta
	 */
	public Conta(double saldo, Cliente titular){
		this.numeroConta = "" + proximoNum++;
		this.saldo = saldo;
		this.titular = titular;
	}
	
	/**
	 * Gets/Sets dos atributos
	 */
	public String getNumeroConta() {
		return numeroConta;
	}
	
	public void setNumeroConta(String numeroConta) {
		this.numeroConta = numeroConta;
	}
	
	
	public Cliente getTitular() {
		return titular;
	}
	
	
	public void setTitular(Cliente titular) {
		this.titular = titular;
	}


	public double getSaldo() {
		return saldo;
	}

	public void setSaldo(double saldo) {
		this.saldo = saldo;
	}
	

	public static int getProximoNum() {
		return proximoNum;
	}

	public static void setProximoNum(int proximoNum) {
		Conta.proximoNum = proximoNum;
	}
	
	/** 
	 * @param Debitar
	 * Retira da conta o valor para ser transferido.
	 */
	public void debitar(double valor){
		setSaldo((getSaldo()-valor));
    }
		
	/**
	 * @param Creditar 
	 * Deposita na conta o valor transferido.
	 */
	public void creditar(double valor){
       	setSaldo((getSaldo()+ valor));
	}
		
	/**
	 * @param Transferir:
	 * Transfere o valor solicitado de uma conta para a outra
	 */
	public void transferir(double valor, Conta contaDestino){
       	debitar(valor);
       	contaDestino.creditar(valor);
	}
}

