/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxSupport;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.UISimpleTogglePanel;
import org.richfaces.event.SimpleToggleEvent;
import org.richfaces.event.SimpleTogglePanelSwitchEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTogglePanelRenderer
extends HeaderResourcesRendererBase {
    static final String NONE = "none";
    static final String EMPTY = "";

    protected Class<? extends UIComponent> getComponentClass() {
        return UISimpleTogglePanel.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void writeEventHandlerFunction(FacesContext context, UIComponent component, String eventName) throws IOException {
        RendererUtils.writeEventHandlerFunction((FacesContext)context, (UIComponent)component, (String)eventName);
    }

    public void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        ExternalContext exCtx = context.getExternalContext();
        Map rqMap = exCtx.getRequestParameterMap();
        Object clnId = rqMap.get(component.getClientId(context));
        UISimpleTogglePanel panel = (UISimpleTogglePanel)component;
        if (clnId != null) {
            boolean currentState = panel.isOpened();
            boolean submittedState = false;
            String switchType = panel.getSwitchType();
            if ("client".equals(switchType)) {
                submittedState = Boolean.parseBoolean((String)clnId);
            } else {
                boolean bl = submittedState = !currentState;
            }
            if (currentState != submittedState) {
                SimpleToggleEvent event = new SimpleToggleEvent((UIComponent)panel, submittedState);
                event.queue();
                SimpleTogglePanelSwitchEvent stateEvent = new SimpleTogglePanelSwitchEvent((UIComponent)panel, submittedState);
                stateEvent.queue();
            }
            if (AjaxRendererUtils.isAjaxRequest((FacesContext)context) && panel.getSwitchType().equals("ajax")) {
                AjaxRendererUtils.addRegionByName((FacesContext)context, (UIComponent)panel, (String)panel.getId());
                AjaxRendererUtils.addRegionsFromComponent((UIComponent)panel, (FacesContext)context);
                AjaxContext.getCurrentInstance((FacesContext)context).addAreasToProcessFromComponent(context, (UIComponent)panel);
            }
        }
    }

    public String getdivdisplay(FacesContext context, UIComponent component) {
        UISimpleTogglePanel simpleTogglePanel = (UISimpleTogglePanel)component;
        return simpleTogglePanel.isOpened() ? EMPTY : NONE;
    }

    public String getOnClick(FacesContext context, UIComponent component) {
        UISimpleTogglePanel tgComp = (UISimpleTogglePanel)component;
        String switchType = tgComp.getSwitchType();
        StringBuffer onClick = new StringBuffer();
        JSReference eventRef = new JSReference("event");
        String panelId = tgComp.getClientId(context);
        if ("client".equals(switchType)) {
            JSFunction function = new JSFunction("SimpleTogglePanelManager.toggleOnClient", new Object[0]);
            function.addParameter((Object)eventRef);
            function.addParameter((Object)panelId);
            function.appendScript(onClick);
            onClick.append(";");
        } else if ("ajax".equals(switchType)) {
            AjaxSupport support;
            JSFunction function = new JSFunction("SimpleTogglePanelManager.toggleOnAjax", new Object[0]);
            function.addParameter((Object)eventRef);
            function.addParameter((Object)panelId);
            function.appendScript(onClick);
            onClick.append(";");
            JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)tgComp, (FacesContext)context);
            ajaxFunction.addParameter((Object)AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)tgComp));
            ajaxFunction.appendScript(onClick);
            if (tgComp instanceof AjaxSupport && (support = (AjaxSupport)tgComp).isDisableDefault()) {
                onClick.append("; return false;");
            }
        } else {
            JSFunction function = new JSFunction("SimpleTogglePanelManager.toggleOnServer", new Object[0]);
            function.addParameter((Object)eventRef);
            function.addParameter((Object)panelId);
            function.appendScript(onClick);
            onClick.append(";");
        }
        return onClick.toString();
    }

    protected String getValueAsString(FacesContext context, UISimpleTogglePanel Panel) {
        return this.getUtils().getValueAsString(context, (UIComponent)Panel);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UISimpleTogglePanel comp = (UISimpleTogglePanel)component;
        if (comp.getSwitchType() != null && comp.getSwitchType().equals("client") || comp.isOpened()) {
            super.encodeChildren(context, component);
        }
    }

    public String getSwitchOnStatus(FacesContext context, UIComponent component) {
        UISimpleTogglePanel simpleTogglePanel = (UISimpleTogglePanel)component;
        return simpleTogglePanel.isOpened() ? EMPTY : NONE;
    }

    public String getSwitchOffStatus(FacesContext context, UIComponent component) {
        UISimpleTogglePanel simpleTogglePanel = (UISimpleTogglePanel)component;
        return simpleTogglePanel.isOpened() ? NONE : EMPTY;
    }
}

