/*
 * Decompiled with CFR 0.152.
 */
package com.gugawag.mytwitter.modelo;

import com.gugawag.mytwitter.modelo.Mensagem;
import com.gugawag.mytwitter.modelo.UsuarioNaoSeguidoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Usuario
implements Serializable {
    private String email;
    private String senha;
    private String nome;
    private List<Mensagem> mensagensEnviadas;
    private List<Mensagem> mensagensRecebidas;
    private Map<String, Usuario> seguidores;
    private Map<String, Usuario> seguidos;

    public Usuario(String nome, String email, String senha) {
        this.nome = nome;
        this.email = email;
        this.senha = senha;
        this.mensagensEnviadas = new ArrayList<Mensagem>();
        this.mensagensRecebidas = new ArrayList<Mensagem>();
        this.seguidores = new HashMap<String, Usuario>();
        this.seguidos = new HashMap<String, Usuario>();
    }

    public Usuario() {
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Map<String, Usuario> getSeguidores() {
        return this.seguidores;
    }

    public void setSeguidores(Map<String, Usuario> seguidores) {
        this.seguidores = seguidores;
    }

    public Map<String, Usuario> getSeguidos() {
        return this.seguidos;
    }

    public void setSeguidos(Map<String, Usuario> seguidos) {
        this.seguidos = seguidos;
    }

    public List<Mensagem> getMensagensEnviadas() {
        return this.mensagensEnviadas;
    }

    public void setMensagensEnviadas(List<Mensagem> mensagensEnviadas) {
        this.mensagensEnviadas = mensagensEnviadas;
    }

    public List<Mensagem> getMensagensRecebidas() {
        return this.mensagensRecebidas;
    }

    public void setMensagensRecebidas(List<Mensagem> mensagensRecebidas) {
        this.mensagensRecebidas = mensagensRecebidas;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public void acrescentarSeguidor(Usuario novoSeguidor) {
        this.seguidores.put(novoSeguidor.getEmail(), novoSeguidor);
    }

    public void seguirUsuario(Usuario novoSeguido) {
        if (!this.seguidos.containsKey(novoSeguido.getEmail())) {
            this.seguidos.put(novoSeguido.getEmail(), novoSeguido);
            novoSeguido.acrescentarSeguidor(this);
        }
    }

    public void pararDeSeguirUsuario(Usuario seguido) throws UsuarioNaoSeguidoException {
        if (!this.seguidos.containsKey(seguido.getEmail())) {
            throw new UsuarioNaoSeguidoException("O usu\u00e1rio " + seguido + " n\u00e3o \u00e9 seguido por " + this);
        }
        this.seguidos.remove(seguido.getEmail());
        seguido.removerSeguidor(this);
    }

    public void enviarMensagem(Mensagem mensagem) {
        mensagem.setPostador(this);
        for (Usuario seguidor : this.seguidores.values()) {
            seguidor.receberMensagem(mensagem);
        }
        this.mensagensEnviadas.add(mensagem);
    }

    public void receberMensagem(Mensagem mensagem) {
        this.mensagensRecebidas.add(mensagem);
    }

    public String toString() {
        return "Nome: " + this.nome + " | email: " + this.email;
    }

    public void removerSeguidor(Usuario seguidor) throws UsuarioNaoSeguidoException {
        if (!this.seguidores.containsKey(seguidor.getEmail())) {
            throw new UsuarioNaoSeguidoException("O usu\u00e1rio " + this + " n\u00e3o \u00e9 seguido por " + seguidor);
        }
        this.seguidores.remove(seguidor.getEmail());
    }
}

