/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.gugawag.mytwitter.beans;

import com.gugawag.mytwitter.armazenamento.UsuarioExistenteException;
import com.gugawag.mytwitter.controle.FachadaMyTwitter;
import com.gugawag.mytwitter.controle.FachadaMyTwitterIF;
import com.gugawag.mytwitter.modelo.*;
import com.sun.faces.util.MessageFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

/**
 *
 * @author gugawag
 */
public class UsuarioBean {

    private Usuario usuario;
    /** Creates a new instance of UsuarioBean */
    public UsuarioBean() {
        usuario = new Usuario();
    }

    public Usuario getUsuario() {
        return usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public String cadastrar(){
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            FachadaMyTwitterIF fachada = FachadaMyTwitter.getInstance();
            fachada.inserirUsuario(usuario);
        } catch (UsuarioExistenteException ex) {
            context.addMessage(null, MessageFactory.getMessage("erro.usuario.existente", new String[]{usuario.toString()}));
            return null;
        }
        context.addMessage(null, MessageFactory.getMessage("info.usuario.cadastro.sucesso", new String[]{}));
        return null;
    }

}
