/*
 * Decompiled with CFR 0.152.
 */
package com.gugawag.mytwitter.controle;

import com.gugawag.mytwitter.armazenamento.RepositorioArquivoUsuarios;
import com.gugawag.mytwitter.armazenamento.UsuarioExistenteException;
import com.gugawag.mytwitter.armazenamento.UsuarioInexistenteException;
import com.gugawag.mytwitter.controle.ControladorUsuarioIF;
import com.gugawag.mytwitter.controle.UsuarioJahSeguidoException;
import com.gugawag.mytwitter.modelo.Mensagem;
import com.gugawag.mytwitter.modelo.Usuario;
import com.gugawag.mytwitter.modelo.UsuarioNaoSeguidoException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControladorUsuario
implements ControladorUsuarioIF {
    private RepositorioArquivoUsuarios repUsuarios;

    public ControladorUsuario(RepositorioArquivoUsuarios repUsuarios) {
        this.repUsuarios = repUsuarios;
    }

    @Override
    public void inserirUsuario(Usuario usuario) throws UsuarioExistenteException {
        Usuario usuarioProcurado = this.repUsuarios.getUsuarioPorEmail(usuario.getEmail());
        if (usuarioProcurado != null) {
            throw new UsuarioExistenteException("Usu\u00e1rio [" + usuario.getEmail() + "] j\u00e1 existe no sistema!");
        }
        this.repUsuarios.inserirUsuario(usuario);
    }

    @Override
    public void removerUsuario(String email) throws UsuarioInexistenteException {
        Usuario usuarioARemover = this.repUsuarios.getUsuarioPorEmail(email);
        if (usuarioARemover == null) {
            throw new UsuarioInexistenteException("Usu\u00e1rio [" + email + "] n\u00e3o existe no sistema!");
        }
        this.repUsuarios.removerUsuario(usuarioARemover);
    }

    @Override
    public Map<String, Usuario> getUsuarios() {
        return this.repUsuarios.getUsuarios();
    }

    @Override
    public Collection<Usuario> getUsuariosComoColecao() {
        return this.repUsuarios.getUsuariosComoColecao();
    }

    @Override
    public Usuario getUsuarioPorEmail(String email) {
        return this.repUsuarios.getUsuarioPorEmail(email);
    }

    @Override
    public void seguirUsuario(Usuario seguidor, Usuario seguido) throws UsuarioJahSeguidoException {
        if (seguidor.getSeguidos().containsKey(seguido.getEmail())) {
            throw new UsuarioJahSeguidoException("O usu\u00e1rio " + seguido + " j\u00e1 \u00e9 seguido por " + seguidor);
        }
        seguidor.seguirUsuario(seguido);
        try {
            this.repUsuarios.salvarDados();
        }
        catch (IOException ex) {
            Logger.getLogger(ControladorUsuario.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void pararDeSeguirUsuario(Usuario seguidor, Usuario seguido) throws UsuarioNaoSeguidoException {
        seguidor.pararDeSeguirUsuario(seguido);
        try {
            this.repUsuarios.salvarDados();
        }
        catch (IOException ex) {
            Logger.getLogger(ControladorUsuario.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void enviarMensagem(Usuario enviador, Mensagem mensagem) {
        enviador.enviarMensagem(mensagem);
        try {
            this.repUsuarios.salvarDados();
        }
        catch (IOException ex) {
            Logger.getLogger(ControladorUsuario.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

