/*
 * Decompiled with CFR 0.152.
 */
package com.gugawag.mytwitter.armazenamento;

import com.gugawag.mytwitter.modelo.Usuario;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorioArquivoUsuarios {
    public String nomeArquivo;
    private Map<String, Usuario> mapaUsuarios;

    public RepositorioArquivoUsuarios() {
        Properties properties = new Properties();
        try {
            String caminhoArquivo = this.getClass().getResource("/com/gugawag/mytwitter/beans/configuracoes.properties").getFile().replaceAll("%20", " ");
            properties.load(new FileInputStream(caminhoArquivo));
        }
        catch (Exception ex) {
            Logger.getLogger(RepositorioArquivoUsuarios.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.nomeArquivo = properties.getProperty("caminho.arquivo.dados");
        File file = new File(this.nomeArquivo);
        if (file.exists()) {
            this.carregarDados();
        } else {
            this.mapaUsuarios = new HashMap<String, Usuario>();
        }
    }

    public void inserirUsuario(Usuario usuario) {
        this.mapaUsuarios.put(usuario.getEmail(), usuario);
        try {
            this.salvarDados();
        }
        catch (IOException ex) {
            Logger.getLogger(RepositorioArquivoUsuarios.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void removerUsuario(Usuario usuarioARemover) {
        this.mapaUsuarios.remove(usuarioARemover);
        try {
            this.salvarDados();
        }
        catch (IOException ex) {
            Logger.getLogger(RepositorioArquivoUsuarios.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Map<String, Usuario> getUsuarios() {
        return this.mapaUsuarios;
    }

    public Collection<Usuario> getUsuariosComoColecao() {
        return this.mapaUsuarios.values();
    }

    public Usuario getUsuarioPorEmail(String email) {
        return this.mapaUsuarios.get(email);
    }

    public void salvarDados() throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.nomeArquivo));
        os.writeObject(this.mapaUsuarios);
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void carregarDados() {
        ObjectInputStream oi = null;
        try {
            oi = new ObjectInputStream(new FileInputStream(this.nomeArquivo));
            this.mapaUsuarios = (Map)oi.readObject();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(RepositorioArquivoUsuarios.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(RepositorioArquivoUsuarios.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                oi.close();
            }
            catch (IOException ex) {
                Logger.getLogger(RepositorioArquivoUsuarios.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

