/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.gugawag.mytwitter.armazenamento;

import com.gugawag.mytwitter.modelo.Usuario;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author gugawag
 */
public class RepositorioArquivoUsuarios {

    public static final String NOME_ARQUIVO = "usuarios.dat";
    //A chave é o email do usuário, e o valor é o próprio objeto Usuario
    private Map<String, Usuario> mapaUsuarios;

    public RepositorioArquivoUsuarios() {
        File file = new File(NOME_ARQUIVO);

        if (file.exists()){
            carregarDados();
        } else{
            mapaUsuarios = new HashMap<String, Usuario>();
        }
    }

    public void inserirUsuario(Usuario usuario){
        mapaUsuarios.put(usuario.getEmail(), usuario);
    }

    public Map<String, Usuario> getUsuarios(){
        return mapaUsuarios;
    }

    public Collection<Usuario> getUsuariosComoColecao(){
        return mapaUsuarios.values();
    }

    public Usuario getUsuarioPorEmail(String email){
        return mapaUsuarios.get(email);
    }

    public void salvarDados() throws IOException{
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(NOME_ARQUIVO));
        os.writeObject(mapaUsuarios);
    }

    public void carregarDados(){
        ObjectInputStream oi = null;
        try {
            oi = new ObjectInputStream(new FileInputStream(NOME_ARQUIVO));
            mapaUsuarios = (Map<String, Usuario>)oi.readObject();
        } catch (ClassNotFoundException ex) {
            Logger.getLogger(RepositorioArquivoUsuarios.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(RepositorioArquivoUsuarios.class.getName()).log(Level.SEVERE, null, ex);
        } finally{
            try {
                oi.close();
            } catch (IOException ex) {
                Logger.getLogger(RepositorioArquivoUsuarios.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }


}
