/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.gugawag.mensagens.modelo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;

@Entity
public class Mensagem implements Serializable{
    private String texto;

    @OneToMany(fetch=FetchType.EAGER, cascade=CascadeType.ALL)
    private List<Comentario> comentarios;
    
    @Id @GeneratedValue
    private Integer codigo;

    public Mensagem(){
        this(null);
    }

    public Mensagem(String texto){
        this.texto = texto;
        comentarios = new ArrayList<Comentario>();
    }

    public Integer getCodigo() {
        return codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public List<Comentario> getComentarios() {
        return comentarios;
    }

    public void setComentarios(List<Comentario> comentarios) {
        this.comentarios = comentarios;
    }

    public String getTexto() {
        return texto;
    }

    public void setTexto(String texto) {
        this.texto = texto;
    }

    public void inserirComentario(Comentario comentario){
        comentarios.add(comentario);
    }

    @Override
    public String toString(){
        StringBuffer sb = new StringBuffer("Código: " + codigo + " Texto: " + texto);
        if (comentarios.size() > 0){
            for(Comentario comentario: getComentarios()){
                sb.append("\n               " + comentario.getTexto());
            }
        }
        return sb.toString();
    }
}
