package com.gugawag.jogos.master.modelo;

import java.util.ArrayList;
import java.util.List;

/**
 * Classe que representa um Cartao do jogo.
 * @author Gustavo Wagner, gugawag@gmail.com
 */
public class Cartao {

	private String descricao;
	private List<String> perguntas, respostas;
	
	
	public Cartao(String descricao){
		this.descricao = descricao;
		this.perguntas = new ArrayList<String>(5);
		this.respostas = new ArrayList<String>(5);
	}

	public String getDescricao() {
		return descricao;
	}
	
	public void acrescentaPergunta(String pergunta){
		this.perguntas.add(pergunta);
	}
	
	public void acrescentaResposta(String resposta){
		this.respostas.add(resposta);
	}

	public List<String> getPerguntas() {
		return perguntas;
	}

	public List<String> getRespostas() {
		return respostas;
	}
	
	public String toString(){
		return "Perguntas: " + perguntas + "\nRespostas:" + respostas; 
	}
	
	
	
}
