package hello.modelo; 

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

@Entity
public class Mensagem implements Serializable{ 
	
    @Id @GeneratedValue 
    private Long id;  
    private String texto; 
    @OneToOne(cascade = CascadeType.ALL) 
    @JoinColumn(name = "NEXT_MESSAGE_ID") 
    private Mensagem proximaMensagem;

    @OneToMany(cascade= CascadeType.ALL, fetch = FetchType.EAGER)
    private List<Comentario> comentarios;
    
    public Mensagem() {
    	this(null);
    } 
    public Mensagem(String texto) { 
        this.texto = texto;
        comentarios = new ArrayList<Comentario>();
    } 
    
    public void acrescentaComentario(Comentario comentario){
    	this.comentarios.add(comentario);
    }
    
	public Long getId() { 
        return id; 
    } 
    private void setId(Long id) { 
        this.id = id; 
    } 
    public String getTexto() { 
        return texto; 
    } 
    public void setTexto(String texto) { 
        this.texto = texto; 
    } 
     public Mensagem getProximaMensagem() { 
         return proximaMensagem; 
     } 
     public void setProximaMensagem(Mensagem proximaMensagem) { 
         this.proximaMensagem = proximaMensagem; 
     } 
     
	public List<Comentario> getComentarios() {
		return comentarios;
	}
	public void setComentarios(List<Comentario> comentarios) {
		this.comentarios = comentarios;
	}
	
    public String toString(){
    	StringBuffer strComentarios = new StringBuffer();
    	for (Comentario comentario : comentarios) {
    		strComentarios.append("\n" + comentario.getTexto());
		}
   	 	return "Texto: " + texto + " Prxima mensagem: " + proximaMensagem + " Comentrios: " + strComentarios.toString();
    }
} 
