package hello.gui;

import hello.dados.RepositorioMensagensIF;
import hello.modelo.Comentario;
import hello.modelo.Mensagem;

import java.util.List;

import javax.naming.InitialContext;
import javax.naming.NamingException;

public class AppMensagem {

	public static void main(String[] args) {
		RepositorioMensagensIF repMensagens = null;
	    try {
	         InitialContext context = new InitialContext();
	         repMensagens = (RepositorioMensagensIF) context.lookup( "RepositorioMensagens/remote" );
	    } catch (NamingException e) {
	        e.printStackTrace();
	    }  
	    
	    Mensagem mensagem1 = new Mensagem("Ol mundo 1");
	    Mensagem mensagem2 = new Mensagem("Ol mundo 2");
	    mensagem1.setProximaMensagem(mensagem2);
	    mensagem1.acrescentaComentario(new Comentario("comentario 1"));
	    mensagem1.acrescentaComentario(new Comentario("comentario 2"));
	    repMensagens.insereMensagem(mensagem1);
	    List<Mensagem> mensagens = repMensagens.getMensagens();
	    for (Mensagem mensagemAtual : mensagens) {
			System.out.println(mensagemAtual);
		}
	}
}
