package hello.dados;

import hello.modelo.Mensagem;

import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Stateless(name="RepositorioMensagens")
public class RepositorioMensagens implements RepositorioMensagensIF{
	
	@PersistenceContext(unitName="HelloWorldJPA")
	private EntityManager em;

	public List<Mensagem> getMensagens() {
		return (List<Mensagem>) em.createQuery("select m from Mensagem m").getResultList();
	}

	public void insereMensagem(Mensagem mensagem) {
		em.persist(mensagem);
	}

	public Mensagem getMensagemInicio(String inicio) {

		return (Mensagem)em.createQuery("from Mensagem where texto like ':inicio%'").setParameter("inicio", inicio).getResultList().get(0);
	}
	
	

}
