/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.io;

import java.io.UnsupportedEncodingException;
import org.ajax4jsf.io.ByteBuffer;

public class CharBuffer {
    private CharBuffer prev;
    private CharBuffer next;
    private char[] chars;
    private int cacheSize;
    private static int MIN_CACHE_SIZE = 64;
    private int usedSize;

    public CharBuffer(int cacheSize) {
        this.cacheSize = cacheSize < MIN_CACHE_SIZE ? MIN_CACHE_SIZE : cacheSize;
        this.chars = new char[this.cacheSize];
        this.usedSize = 0;
    }

    public CharBuffer(char[] chars) {
        this.chars = chars;
        this.usedSize = chars.length;
        this.cacheSize = this.usedSize < MIN_CACHE_SIZE ? MIN_CACHE_SIZE : this.usedSize;
    }

    public CharBuffer append(char c) {
        if (this.next != null) {
            return this.next.append(c);
        }
        if (this.usedSize < this.cacheSize) {
            this.chars[this.usedSize] = c;
            ++this.usedSize;
            return this;
        }
        this.next = new CharBuffer(this.cacheSize * 2);
        this.next.prev = this;
        return this.next.append(c);
    }

    public CharBuffer append(char[] cs, int off, int len) {
        if (this.next != null) {
            return this.next.append(cs, off, len);
        }
        if (len + this.usedSize <= this.cacheSize) {
            System.arraycopy(cs, off, this.chars, this.usedSize, len);
            this.usedSize += len;
            return this;
        }
        int av = this.cacheSize - this.usedSize;
        if (av > 0) {
            System.arraycopy(cs, off, this.chars, this.usedSize, av);
            this.usedSize += av;
            off += av;
            len -= av;
        }
        this.next = new CharBuffer(this.cacheSize * 2);
        this.next.prev = this;
        return this.next.append(cs, off, len);
    }

    public char[] getChars() {
        return this.chars;
    }

    public char getCharAt(int index) {
        return this.chars[index];
    }

    public int getUsedSize() {
        return this.usedSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getTotalSize() {
        return this.prev == null ? this.usedSize : this.prev.getTotalSize() + this.usedSize;
    }

    public CharBuffer getPrevious() {
        return this.prev;
    }

    public CharBuffer getNext() {
        return this.next;
    }

    public void setNext(CharBuffer b) {
        this.next = b;
        if (b != null) {
            b.prev = this;
        }
    }

    public ByteBuffer toByteBuffer(String encoding) throws UnsupportedEncodingException {
        byte[] bs = new String(this.chars, 0, this.usedSize).getBytes(encoding);
        return new ByteBuffer(bs);
    }

    public ByteBuffer toByteBuffer() {
        byte[] bs = new String(this.chars, 0, this.usedSize).getBytes();
        return new ByteBuffer(bs);
    }
}

