<%-- 
    Document   : cadastrarUsuario
    Created on : 18/04/2011, 17:15:54
    Author     : gwmendes
--%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>

<%@taglib prefix="f" uri="http://java.sun.com/jsf/core"%>
<%@taglib prefix="h" uri="http://java.sun.com/jsf/html"%>
<%@taglib prefix="rich" uri="http://richfaces.org/rich"%>
<%@taglib prefix="a4j" uri="http://richfaces.org/a4j"%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
   "http://www.w3.org/TR/html4/loose.dtd">

<f:view>
    <html>
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
            <title>JSP Page</title>
        </head>
        <body>
            <rich:panel>
                <h:messages/>
                <f:facet name="header">Cadastro de Usuário</f:facet>
                <h:form id="form">
                        <h:outputText value="Nome:"/><h:inputText id="nome" value="#{usuarioBean.usuario.nome}" required="true"/><br/>
                        <h:outputText value="Login:"/>
                        <h:inputText value="#{usuarioBean.usuario.login}" id="login" required="true">
                            <f:validateLength minimum="8" maximum="10"/>
                        </h:inputText><br/>
                        <h:outputText value="Senha:"/>
                        <h:inputSecret value="#{usuarioBean.usuario.senha}" id="senha" required="true">
                            <a4j:support event="onkeyup" reRender="labelConfSenhas"/>
                        </h:inputSecret>

                        <h:outputLabel value="#{usuarioBean.textoConferenciaSenhas}" id="labelConfSenhas"/>
                            
                            <br/>

                        <h:outputText value="Senha Redigitada:"/>
                        <h:inputSecret value="#{usuarioBean.senhaRedigitada}" id="senhaRedigitada" required="true">
                            <a4j:support event="onkeyup" reRender="labelConfSenhas"/>
                        </h:inputSecret>
                            <br/>
                        <h:commandButton actionListener="#{usuarioBean.cadastrar}" value="Cadastrar"/>
                </h:form>
            </rich:panel>

            <br/><br/>
            <rich:dataTable value="#{usuarioBean.usuarios}" var="usuario">
                <f:facet name="header">
                    <rich:columnGroup>
                        <h:column>Nome</h:column>
                        <h:column>Login</h:column>
                    </rich:columnGroup>
                </f:facet>
                <h:column>
                    <h:outputText value="#{usuario.nome}"/>
                </h:column>
                <h:column>
                    <h:outputText value="#{usuario.login}"/>
                </h:column>
            </rich:dataTable>
        </body>
    </html>
</f:view>
