/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.gugawag.clubealunos.bean;

import com.gugawag.dados.UsuarioManager;
import com.gugawag.modelo.Usuario;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;


/**
 *
 * @author gwmendes
 */
public class UsuarioBean {


    private Usuario usuario;
    private String senhaRedigitada;
    
    //Gestor de usuários e seus dependentes. Simula um banco de dados. Salva em arquivo.
    private UsuarioManager um;

    /** Creates a new instance of UsuarioBean */
    public UsuarioBean() {
        usuario = new Usuario();
        um = new UsuarioManager();
        senhaRedigitada = new String();
    }

    public Usuario getUsuario() {
        return usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public String getSenhaRedigitada() {
        return senhaRedigitada;
    }

    public void setSenhaRedigitada(String senhaRedigitada) {
        this.senhaRedigitada = senhaRedigitada;
    }

    public String getTextoConferenciaSenhas() {
        if (senhasConferem()){
            return "Senhas conferem";
        }
        return "Senhas não conferem";
    }


    public DataModel getUsuarios(){
        return new ListDataModel(um.getUsuarios());
    }

    private boolean senhasConferem(){
        return senhaRedigitada.equals(usuario.getSenha());
    }

    public void cadastrar(ActionEvent event){
        //Pegando a instância corrente do JSF para acrescentar mensagens.
        FacesContext context = FacesContext.getCurrentInstance();
        if (senhasConferem()){
            um.acrescentaUsuario(new Usuario(usuario.getLogin(), usuario.getSenha(), usuario.getNome(), null));
            um.salvarUsuarios();
            context.addMessage(null, new FacesMessage("Usuário cadastrado com sucesso!"));
        }else{
            context.addMessage(null, new FacesMessage("Senhas não conferem!"));
        }

    }



}
