/*
 * Decompiled with CFR 0.152.
 */
package com.gugawag.dados;

import com.gugawag.modelo.Usuario;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UsuarioManager {
    private List<Usuario> usuarios = new ArrayList<Usuario>();
    private static final String NOME_ARQUIVO = "dados.dat";
    private FileOutputStream arquivoSaida;

    public UsuarioManager() {
        try {
            this.carregaUsuarios();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(UsuarioManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(UsuarioManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(UsuarioManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public List<Usuario> getUsuarios() {
        return this.usuarios;
    }

    public void setUsuarios(List<Usuario> usuarios) {
        this.usuarios = usuarios;
    }

    public void acrescentaUsuario(Usuario usuario) {
        this.usuarios.add(usuario);
    }

    public void removeUsuario(Usuario usuario) {
        this.usuarios.remove(usuario);
    }

    public void carregaUsuarios() throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream objectIn = new ObjectInputStream(new BufferedInputStream(new FileInputStream(NOME_ARQUIVO)));
        Object objRetornado = objectIn.readObject();
        if (objRetornado != null) {
            this.usuarios = (List)objRetornado;
        }
        objectIn.close();
    }

    public void salvarUsuarios() {
        try {
            ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(NOME_ARQUIVO)));
            objectOut.writeObject(this.usuarios);
            objectOut.close();
        }
        catch (IOException ex) {
            Logger.getLogger(UsuarioManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

