package com.gugawag.tw.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jboss.logging.Logger;

import com.gugawag.tw.modelo.Produto;

public class ListarProdutosServlet extends HttpServlet {

	private Logger logger = Logger.getLogger("carrinhocompras");
	
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		
		List<Produto> produtos = (List<Produto>)getServletContext().getAttribute("produtos");
		PrintWriter writer = response.getWriter();
		writer.write("<html>");
		writer.write("<body>");
		writer.write("<h1>Produtos a Venda</h1>");
		writer.write("<table border=\"1\">");
		
		writer.write("<tr>");
		writer.write("<td>");		
		writer.write("<b>Descricao Produto</b>");
		writer.write("</td>");
		writer.write("<td>");		
		writer.write("<b>Preco</b>");
		writer.write("</td>");		
		writer.write("</tr>");
		
		for (Produto produto : produtos) {
			writer.write("<tr>");
			writer.write("<td>");
			writer.write("<a href=\"InsereProduto.do?codigo="+ produto.getCodigo() +"\">" + produto.getDescricao()+"</a>");
			writer.write("</td>");
			writer.write("<td>");		
			writer.write("" + produto.getPreco());
			writer.write("</td>");		
			writer.write("</tr>");			
		}
		
		writer.write("</table>");
		writer.write("</body>");
		writer.write("</html>");
		writer.flush();
	}
	
}
