/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import java.io.Serializable;
import java.util.Set;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.richfaces.validator.GraphValidator;
import org.richfaces.validator.HibernateValidator;
import org.richfaces.validator.ObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesBeanValidator
implements Validator,
Serializable,
GraphValidator {
    private static final long serialVersionUID = -264568176252121853L;
    public static final String BEAN_VALIDATOR_TYPE = "org.richfaces.BeanValidator";
    private ValueExpression summaryExpression = null;
    private String summary = null;
    private ValueExpression profilesExpression = null;
    private Set<String> profiles = null;

    public String getSummary() {
        String summaryString = null;
        summaryString = null != this.summaryExpression ? (String)this.summaryExpression.getValue(FacesContext.getCurrentInstance().getELContext()) : this.summary;
        return summaryString;
    }

    public void setSummary(ValueExpression summary) {
        this.summaryExpression = summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void validate(FacesContext context, UIComponent component, Object convertedValue) throws ValidatorException {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            try {
                String[] messages;
                ValueExpression valueExpression = component.getValueExpression("value");
                if (null != valueExpression && null != (messages = HibernateValidator.getInstance(context).validate(context, valueExpression, convertedValue, this.getProfiles()))) {
                    input.setValid(false);
                    for (String msg : messages) {
                        String summaryString = this.getSummary() != null ? this.getSummary() : msg;
                        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, summaryString, msg));
                    }
                }
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    @Override
    public String[] validateGraph(FacesContext context, UIComponent component, Object value, Set<String> profiles) throws ValidatorException {
        ObjectValidator beanValidator = HibernateValidator.getInstance(context);
        String[] messages = beanValidator.validateGraph(context, value, profiles);
        return messages;
    }

    public Set<String> getProfiles() {
        Set profiles = null != this.profilesExpression ? (Set)this.profilesExpression.getValue(FacesContext.getCurrentInstance().getELContext()) : this.profiles;
        return profiles;
    }

    public void setProfiles(Set<String> profiles) {
        this.profiles = profiles;
    }

    public void setProfiles(ValueExpression profilesExpression) {
        this.profilesExpression = profilesExpression;
    }
}

