/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.richfaces.component.UIColumn;
import org.richfaces.renderkit.html.TableMenuRenderer;

public class SimpleTableMenuRenderer
extends TableMenuRenderer {
    private static final long serialVersionUID = -3907452284006250197L;
    private int visibleColumnsCount;
    private ResponseWriter writer;

    public String render() throws IOException {
        String menuId = this.table.getClientId(this.context) + ":tm";
        Iterator<UIColumn> columns = this.table.getSortedColumns();
        this.visibleColumnsCount = this.table.getVisibleColumnsCount();
        this.writer = this.context.getResponseWriter();
        this.writer.startElement("div", (UIComponent)this.table);
        this.writer.writeAttribute("id", (Object)menuId, null);
        this.writer.writeAttribute("class", (Object)"dt-menu", null);
        this.writer.writeAttribute("style", (Object)"z-index: 15005; visibility: visible; left: 0px; top: 0px;", null);
        this.writer.startElement("ul", (UIComponent)this.table);
        this.writer.writeAttribute("class", (Object)"dt-menu-list", null);
        while (columns.hasNext()) {
            this.renderMenuItem(columns.next());
        }
        this.writer.endElement("ul");
        this.writer.endElement("div");
        return menuId;
    }

    protected void renderMenuItem(UIColumn column) throws IOException {
        if (column instanceof UIColumn) {
            UIColumn dataColumn = column;
            Boolean v = dataColumn.isVisible();
            boolean columnVisible = v == null ? Boolean.TRUE : v;
            String actionScript = null;
            if (!columnVisible || this.visibleColumnsCount > 1) {
                HashMap<String, String> parameters;
                boolean ajaxSingle = true;
                Map requestOpts = AjaxRendererUtils.buildEventOptions((FacesContext)this.context, (UIComponent)dataColumn);
                if (this.onAjaxCompleteFunction != null) {
                    requestOpts.put("oncomplete", this.onAjaxCompleteFunction);
                }
                if ((parameters = (HashMap<String, String>)requestOpts.get("parameters")) == null) {
                    parameters = new HashMap<String, String>();
                    requestOpts.put("parameters", parameters);
                }
                if (ajaxSingle) {
                    if (!parameters.containsKey("ajaxSingle")) {
                        parameters.put("ajaxSingle", dataColumn.getParent().getClientId(this.context));
                    }
                    if (!requestOpts.containsKey("control")) {
                        requestOpts.put("control", JSReference.THIS);
                    }
                }
                parameters.put(dataColumn.getParent().getClientId(this.context) + ":" + "change_col_v", dataColumn.getId());
                JSFunction dropFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)dataColumn, (FacesContext)this.context);
                dropFunction.addParameter((Object)requestOpts);
                actionScript = dropFunction.toScript();
            }
            this.writer.startElement("li", (UIComponent)dataColumn);
            this.writer.writeAttribute("class", (Object)("dt-menu-list-item" + (columnVisible ? " dt-menu-item-checked" : "")), null);
            this.writer.startElement("a", (UIComponent)dataColumn);
            this.writer.writeAttribute("href", (Object)"#", null);
            this.writer.writeAttribute("class", (Object)"dt-menu-item dt-menu-check-item", null);
            actionScript = actionScript == null ? "return false;" : actionScript + ";return false;";
            this.writer.writeAttribute("onclick", (Object)actionScript, null);
            this.writer.startElement("img", (UIComponent)dataColumn);
            this.writer.writeAttribute("class", (Object)"dt-menu-item-icon", null);
            InternetResource res = InternetResourceBuilder.getInstance().getResource("/org/richfaces/renderkit/html/images/s.gif");
            this.writer.writeAttribute("src", (Object)InternetResourceBuilder.getInstance().getUri(res, this.context, null), null);
            this.writer.endElement("img");
            String label = (String)dataColumn.getAttributes().get("label");
            this.writer.writeText((Object)(label == null ? "" : label), null);
            this.writer.endElement("a");
            this.writer.endElement("li");
        }
    }

    public JSFunctionDefinition createShowMenuEventFunction() {
        return new JSFunctionDefinition(new Object[0]);
    }
}

