/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.gugawag.mytwitter.modelo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author gugawag
 */
public class Usuario implements Serializable{
    private String email;
    private String senha;
    private List<Mensagem> mensagensEnviadas;
    private List<Mensagem> mensagensRecebidas;
    private Map<String, Usuario> seguidores;
    private Map<String, Usuario> seguidos;

    public Usuario(String email, String senha) {
        this.email = email;
        this.senha = senha;
        mensagensEnviadas = new ArrayList<Mensagem>();
        mensagensRecebidas = new ArrayList<Mensagem>();
        seguidores = new HashMap<String, Usuario>();
        seguidos = new HashMap<String, Usuario>();
    }

    public Usuario() {
    }

    public Map<String, Usuario> getSeguidores() {
        return seguidores;
    }

    public void setSeguidores(Map<String, Usuario> seguidores) {
        this.seguidores = seguidores;
    }

    public Map<String, Usuario> getSeguidos() {
        return seguidos;
    }

    public void setSeguidos(Map<String, Usuario> seguidos) {
        this.seguidos = seguidos;
    }

    public List<Mensagem> getMensagensEnviadas() {
        return mensagensEnviadas;
    }

    public void setMensagensEnviadas(List<Mensagem> mensagensEnviadas) {
        this.mensagensEnviadas = mensagensEnviadas;
    }

    public List<Mensagem> getMensagensRecebidas() {
        return mensagensRecebidas;
    }

    public void setMensagensRecebidas(List<Mensagem> mensagensRecebidas) {
        this.mensagensRecebidas = mensagensRecebidas;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSenha() {
        return senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public void acrescentarSeguidor(Usuario novoSeguidor){
        this.seguidores.put(novoSeguidor.getEmail(), novoSeguidor);
    }

    public void seguirUsuario(Usuario novoSeguido){
        //só acrescenta se não já seguir
        if (!seguidos.containsKey(novoSeguido.getEmail())){
            this.seguidos.put(novoSeguido.getEmail(), novoSeguido);
            novoSeguido.acrescentarSeguidor(this);
        }
    }

    public void enviarMensagem(Mensagem mensagem){        
        for(Usuario seguidor: seguidores.values()){
            seguidor.receberMensagem(mensagem);
        }
        mensagensEnviadas.add(mensagem);
    }

    public void receberMensagem(Mensagem mensagem){
        this.mensagensRecebidas.add(mensagem);
    }

}
