package com.gugawag.jogos.master.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

import com.gugawag.jogos.master.modelo.Cartao;

/**
 * Classe que representa um Leitor de Cartas. Essa classe leh as cartas e as disponibiliza via o metodo getCartao().
 * @author Gustavo Wagner, gugawag@gmail.com
 *
 */
public class LeitorCartas {
	
	private Properties cartoes;
	private static LeitorCartas instance;
	
	public static LeitorCartas getInstance(){
		if (instance == null){
			instance = new LeitorCartas();
		}
		return instance;
	}
	private LeitorCartas(){
		cartoes = new Properties();
	}
	
	/**
	 * Carrega os cartoes e os deixa disponiveis.
	 * @return A quantidade de cartoes carregados.
	 */
	public int carregaCartoes(){
		try {		
			cartoes.load(new FileInputStream("C://Documents and Settings//profgustavo//Meus documentos//NetBeansProjects//JogoMaster//web//resources//cartoes.properties"));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e){
			e.printStackTrace();
		}	
		//como metade do arquivo eh de perguntas e metade eh de resposta, divide-se por 2
		return cartoes.size()/2;
	}

	/**
	 * Retorna a carta cujo numero seja o passado como parametro.
	 * @param numero O numero do cartao solicitado
	 * @return O cartao representando pelo numero passado, ou null, caso nao exista.
	 */
	public Cartao pegaCartao(int numero){
		String numeroCartao = "c" + numero;
		String perguntas = cartoes.getProperty(numeroCartao);
		if (perguntas == null){
			return null;
		}
		String respostas = cartoes.getProperty("r"+numero);
		StringTokenizer perguntasToken = new StringTokenizer(perguntas, "|");
		StringTokenizer respostasToken = new StringTokenizer(respostas, "|");
		String perguntaAtual, respostaAtual = null;
		Cartao cartao = new Cartao(numeroCartao);
		while(perguntasToken.hasMoreTokens()){
			perguntaAtual = perguntasToken.nextToken();
			//A carta pode ter resposta ou nao.
			if (respostasToken.hasMoreTokens()){
				respostaAtual = respostasToken.nextToken();
				cartao.acrescentaResposta(respostaAtual);
			} else{
				cartao.acrescentaResposta("Sem resposta.");
			}
			cartao.acrescentaPergunta(perguntaAtual);
			
		}
		return cartao;
	}

}
