/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import javax.faces.event.PhaseId;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.util.SelectUtils;
import org.richfaces.component.UICalendar;
import org.richfaces.component.util.ComponentUtil;
import org.richfaces.event.CurrentDateChangeEvent;
import org.richfaces.renderkit.TemplateEncoderRendererBase;

public class CalendarRendererBase
extends TemplateEncoderRendererBase {
    protected static final String MONTH_LABELS_SHORT = "monthLabelsShort";
    protected static final String MONTH_LABELS = "monthLabels";
    protected static final String WEEK_DAY_LABELS_SHORT = "weekDayLabelsShort";
    protected static final String WEEK_DAY_LABELS = "weekDayLabels";
    public static final String DATE_SCROLL = "DateScroll";
    protected static final String MARKUP_SUFFIX = "Markup";
    static /* synthetic */ Class class$org$richfaces$component$UICalendar;

    protected Class getComponentClass() {
        return class$org$richfaces$component$UICalendar == null ? (class$org$richfaces$component$UICalendar = CalendarRendererBase.class$("org.richfaces.component.UICalendar")) : class$org$richfaces$component$UICalendar;
    }

    public void addPopupToAjaxRendered(FacesContext context, UICalendar component) {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (ajaxContext.isAjaxRequest()) {
            ajaxContext.getAjaxRenderedAreas().add(component.getClientId(context) + "Popup");
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof Date) {
            return (Date)submittedValue;
        }
        UICalendar calendar = (UICalendar)component;
        if (calendar.getConverter() != null) {
            return calendar.getConverter().getAsObject(context, component, (String)submittedValue);
        }
        DateTimeConverter converter = new DateTimeConverter();
        converter.setPattern(calendar.getDatePattern());
        converter.setLocale(calendar.getLocale());
        converter.setTimeZone(calendar.getTimeZone());
        return converter.getAsObject(context, component, (String)submittedValue);
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String selectedDateString;
        super.doDecode(context, component);
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String currentDateString = (String)requestParameterMap.get(clientId + DATE_SCROLL);
        if (currentDateString != null) {
            CurrentDateChangeEvent ev = new CurrentDateChangeEvent(component, currentDateString);
            ev.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
            ev.queue();
            new AjaxEvent(component).queue();
        }
        if ((selectedDateString = (String)requestParameterMap.get(clientId + "InputDate")) != null) {
            ((UICalendar)component).setSubmittedValue(selectedDateString);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent calendar) throws IOException {
    }

    public void writeMarkupScriptBody(FacesContext context, UIComponent component, boolean children) throws IOException {
        this.writeScriptBody(context, component, children);
    }

    public void writeFacetMarkupScriptBody(FacesContext context, UIComponent component, String facetName) throws IOException {
        UIComponent facet = component.getFacet(facetName);
        if (facet != null && facet.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeText((Object)(", " + facetName + MARKUP_SUFFIX + ": "), null);
            this.writeMarkupScriptBody(context, facet, false);
        }
    }

    public void writePreloadBody(FacesContext context, UICalendar calendar) throws IOException {
        Object preload = calendar.getPreload();
        if (preload != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.write(ScriptUtils.toScript((Object)preload));
        }
    }

    public void writeSubmitFunction(FacesContext context, UICalendar calendar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = calendar.getClientId(context);
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)calendar, (FacesContext)context, (String)"A4J.AJAX.Submit");
        ajaxFunction.addParameter((Object)JSReference.NULL);
        Map options = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)calendar);
        options.put("calendar", JSReference.THIS);
        boolean isSingle = (Boolean)calendar.getAttributes().get("ajaxSingle");
        if (isSingle) {
            options.put("single", JSReference.TRUE);
        }
        String oncomplete = AjaxRendererUtils.getAjaxOncomplete((UIComponent)calendar);
        JSFunctionDefinition oncompleteDefinition = new JSFunctionDefinition();
        oncompleteDefinition.addParameter((Object)"request");
        oncompleteDefinition.addParameter((Object)"event");
        oncompleteDefinition.addParameter((Object)"data");
        oncompleteDefinition.addToBody((Object)"this.calendar.load(data, true);");
        if (oncomplete != null) {
            oncompleteDefinition.addToBody((Object)oncomplete);
        }
        options.put("oncomplete", oncompleteDefinition);
        Map parametersMap = (Map)options.get("parameters");
        JSReference requestValue = new JSReference("requestValue");
        parametersMap.remove(clientId);
        parametersMap.put(clientId + DATE_SCROLL, requestValue);
        ajaxFunction.addParameter((Object)options);
        JSFunctionDefinition definition = new JSFunctionDefinition();
        definition.addParameter((Object)requestValue);
        definition.addToBody((Object)ajaxFunction);
        writer.write(definition.toScript());
    }

    public void writeEventHandlerFunction(FacesContext context, UIComponent component, String eventName) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object script = component.getAttributes().get(eventName);
        if (script != null && !script.equals("")) {
            JSFunctionDefinition onEventDefinition = new JSFunctionDefinition();
            onEventDefinition.addParameter((Object)"event");
            onEventDefinition.addToBody(script);
            writer.writeText((Object)(",\n" + eventName + ": " + onEventDefinition.toScript()), null);
        }
    }

    public String getInputValue(FacesContext context, UIComponent component) {
        UICalendar input = (UICalendar)component;
        Object value = input.getSubmittedValue();
        Object curVal = input.getValue();
        if (value == null) {
            DateTimeConverter converter = new DateTimeConverter();
            converter.setPattern(input.getDatePattern());
            converter.setLocale(input.getLocale());
            converter.setTimeZone(input.getTimeZone());
            return converter.getAsString(context, (UIComponent)input, curVal);
        }
        if (value instanceof Date) {
            DateTimeConverter converter = new DateTimeConverter();
            converter.setPattern(input.getDatePattern());
            converter.setLocale(input.getLocale());
            return converter.getAsString(context, (UIComponent)input, value);
        }
        if (value instanceof String) {
            Converter converter = SelectUtils.getConverterForProperty((FacesContext)context, (UIOutput)input, (String)"value");
            return converter.getAsString(context, (UIComponent)input, value);
        }
        return null;
    }

    public void writeSymbols(FacesContext facesContext, UICalendar calendar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Map symbolsMap = this.getSymbolsMap(facesContext, calendar);
        Iterator entryIterator = symbolsMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            writer.writeText((Object)ScriptUtils.toScript(entry.getKey()), null);
            writer.writeText((Object)": ", null);
            writer.writeText((Object)ScriptUtils.toScript(entry.getValue()), null);
            if (!entryIterator.hasNext()) continue;
            writer.writeText((Object)", ", null);
        }
    }

    private static String[] shiftDates(int minimum, int maximum, String[] labels) {
        if (minimum == 0 && maximum - minimum == labels.length - 1) {
            return labels;
        }
        String[] shiftedLabels = new String[maximum - minimum + 1];
        System.arraycopy(labels, minimum, shiftedLabels, 0, maximum - minimum + 1);
        return shiftedLabels;
    }

    protected Map getSymbolsMap(FacesContext facesContext, UICalendar calendar) {
        String[] monthLabelsShort;
        String[] monthLabels;
        String[] weekDayLabelsShort;
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Locale locale = calendar.getLocale();
        Calendar cal = calendar.getCalendar();
        int maximum = cal.getActualMaximum(7);
        int minimum = cal.getActualMinimum(7);
        int monthMax = cal.getActualMaximum(2);
        int monthMin = cal.getActualMinimum(2);
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        String[] weekDayLabels = ComponentUtil.asArray((Object)calendar.getWeekDayLabels());
        if (weekDayLabels == null) {
            weekDayLabels = symbols.getWeekdays();
            weekDayLabels = CalendarRendererBase.shiftDates(minimum, maximum, weekDayLabels);
        }
        if ((weekDayLabelsShort = ComponentUtil.asArray((Object)calendar.getWeekDayLabelsShort())) == null) {
            weekDayLabelsShort = symbols.getShortWeekdays();
            weekDayLabelsShort = CalendarRendererBase.shiftDates(minimum, maximum, weekDayLabelsShort);
        }
        if ((monthLabels = ComponentUtil.asArray((Object)calendar.getMonthLabels())) == null) {
            monthLabels = symbols.getMonths();
            monthLabels = CalendarRendererBase.shiftDates(monthMin, monthMax, monthLabels);
        }
        if ((monthLabelsShort = ComponentUtil.asArray((Object)calendar.getMonthLabelsShort())) == null) {
            monthLabelsShort = symbols.getShortMonths();
            monthLabelsShort = CalendarRendererBase.shiftDates(monthMin, monthMax, monthLabelsShort);
        }
        map.put(WEEK_DAY_LABELS, weekDayLabels);
        map.put(WEEK_DAY_LABELS_SHORT, weekDayLabelsShort);
        map.put(MONTH_LABELS, monthLabels);
        map.put(MONTH_LABELS_SHORT, monthLabelsShort);
        return map;
    }

    public String getFirstWeekDay(FacesContext context, UICalendar calendar) throws IOException {
        Calendar cal = calendar.getCalendar();
        return String.valueOf(cal.getFirstDayOfWeek() - cal.getActualMinimum(7));
    }

    public String getMinDaysInFirstWeek(FacesContext context, UICalendar calendar) throws IOException {
        Calendar cal = calendar.getCalendar();
        return String.valueOf(cal.getMinimalDaysInFirstWeek());
    }

    public String getCurrentDate(FacesContext context, UICalendar calendar) throws IOException {
        Date date = calendar.getCurrentDateOrDefault();
        return ScriptUtils.toScript((Object)CalendarRendererBase.formatDate(date));
    }

    public String getSelectedDate(FacesContext context, UICalendar calendar) throws IOException {
        Date date;
        Object submittedValue = calendar.getSubmittedValue();
        if (submittedValue instanceof String) {
            Converter converter = SelectUtils.getConverterForProperty((FacesContext)context, (UIOutput)calendar, (String)"value");
            date = (Date)converter.getAsObject(context, (UIComponent)calendar, (String)submittedValue);
        } else {
            date = submittedValue != null ? (Date)submittedValue : (Date)calendar.getValue();
        }
        if (date != null) {
            return ScriptUtils.toScript((Object)CalendarRendererBase.formatDate(date));
        }
        return ScriptUtils.toScript(null);
    }

    public static Object formatDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        JSFunction result = new JSFunction("new Date");
        result.addParameter((Object)calendar.get(1));
        result.addParameter((Object)calendar.get(2));
        result.addParameter((Object)calendar.get(5));
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

