/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.UIInputNumberSlider;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.InputRendererBase;

public class InputNumberSliderRendererBase
extends InputRendererBase {
    protected Class getComponentClass() {
        return UIInputNumberSlider.class;
    }

    protected boolean attributeToBoolean(UIComponent component, String attributeName) {
        return this.getUtils().isBooleanAttribute(component, attributeName);
    }

    public void writeEventHandlerFunction(FacesContext context, UIComponent component, String eventName) throws IOException {
        RendererUtils.writeEventHandlerFunction((FacesContext)context, (UIComponent)component, (String)eventName);
    }

    public void prepareVariables(FacesContext context, UIInputNumberSlider slider) {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)slider);
        String inputPosition = (String)slider.getAttributes().get("inputPosition");
        if (!("right".equals(inputPosition) || "left".equals(inputPosition) || "top".equals(inputPosition) || "bottom".equals(inputPosition))) {
            inputPosition = "right";
        }
        if ("bottom".equals(inputPosition)) {
            inputPosition = "left";
        }
        if ("top".equals(inputPosition)) {
            inputPosition = "right";
        }
        variables.setVariable("inputPosition", (Object)inputPosition);
        boolean disabled = this.attributeToBoolean((UIComponent)slider, "disabled");
        boolean showInput = this.attributeToBoolean((UIComponent)slider, "showInput");
        boolean manualInput = this.attributeToBoolean((UIComponent)slider, "enableManualInput");
        variables.setVariable("showInput", (Object)new Boolean(showInput));
        variables.setVariable("inputReadOnly", (Object)new Boolean(!manualInput));
        variables.setVariable("inputDisabled", (Object)new Boolean(disabled));
        if (!manualInput || disabled) {
            variables.setVariable("color", (Object)"color: gray;");
        } else {
            variables.setVariable("color", (Object)"");
        }
        variables.setVariable("inputSize", slider.getAttributes().get("inputSize"));
        variables.setVariable("style", (Object)this.getStyleValue(slider));
        variables.setVariable("orientation", slider.getAttributes().get("orientation"));
        boolean showArrows = this.attributeToBoolean((UIComponent)slider, "showArrows");
        variables.setVariable("showArrows", (Object)new Boolean(showArrows));
        variables.setVariable("delay", slider.getAttributes().get("delay"));
    }

    public String getStyleValue(UIInputNumberSlider slider) {
        StringBuffer buf = new StringBuffer();
        String width = slider.getWidth();
        String height = slider.getHeight();
        String style = slider.getStyle();
        if (width != null && width.length() > 0) {
            buf.append("width:" + HtmlUtil.qualifySize((String)width));
            buf.append(";");
        }
        if (height != null && height.length() > 0) {
            buf.append("height:" + HtmlUtil.qualifySize((String)height));
            buf.append(";");
        }
        if (style != null && style.length() > 0) {
            buf.append(style);
        }
        return buf.toString();
    }
}

