package com.gugawag.tw.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.gugawag.tw.modelo.Carrinho;
import com.gugawag.tw.modelo.Produto;

public class ListaCarrinhoServlet extends HttpServlet {

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		
		HttpSession secao = request.getSession(false);

		Carrinho carrinho = null;
		if (secao != null){
			Object objeto = secao.getAttribute("carrinho");
			if (objeto != null){
				carrinho = (Carrinho) objeto;
			}
		}
				
		PrintWriter writer = response.getWriter();
		
		writer.write("<html>");
		writer.write("<body>");
		
		//Nao ha secao
		if (carrinho == null){
			writer.write("<h1>Carrinho vazio!</h1>");
		} else{
			writer.write("<h1>Carrinho:</h1><br>");
			writer.write("<table border=\"1\">");		
			writer.write("<tr>");
			writer.write("<td>");		
			writer.write("<b>Descricao Produto</b>");
			writer.write("</td>");
			writer.write("<td>");		
			writer.write("<b>Preco</b>");
			writer.write("</td>");		
			writer.write("</tr>");
	
			double valorTotal = 0;
			for (Produto produto : carrinho.getProdutos()) {
				writer.write("<tr>");
				writer.write("<td><b>");
				writer.write(produto.getDescricao());
				writer.write(produto.getCodigo());
				writer.write("</b></td>");
				writer.write("<td>");		
				writer.write("" + produto.getPreco());
				writer.write("</td>");		
				writer.write("</tr>");
				valorTotal += produto.getPreco();
				
			}
			writer.write("<tr>");
			writer.write("<td>");		
			NumberFormat formatador = DecimalFormat.getCurrencyInstance();			
			writer.write("Valor total: " + formatador.format(valorTotal));
			writer.write("</td>");		
			writer.write("</tr>");

			writer.write("</table>");
		}
		writer.write("</body>");
		writer.write("</html>");
		writer.flush();		
		
	}
	

}
