/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package appjpa.controle;

import appjpa.modelo.Cliente;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 *
 * @author Gustavo Wagner, gugawag@gmail.com
 */
@Stateless(name="FachadaExemplo")
public class Fachada implements FachadaIF{

    @PersistenceContext(unitName="ExemploPU")
    private EntityManager em;

    public void inserirCliente(Cliente cliente) {
        em.persist(cliente);
    }

    public Cliente pesquisarClientePorEmail(String email) {
        Object ob = em.createQuery("from Cliente c where c.email = :email").setParameter("email", email).getSingleResult();
        Cliente cliente = null;
        if (ob != null){
            cliente = (Cliente) ob;
        }
        return cliente;
    }

    public Cliente pesquisarClientePorCodigo(int codigo) {
        return em.find(Cliente.class, codigo);
    }

}
