/*
 * Decompiled with CFR 0.152.
 */
package com.gugawag.mytwitter.controle;

import com.gugawag.mytwitter.armazenamento.RepositorioArquivoUsuarios;
import com.gugawag.mytwitter.armazenamento.UsuarioExistenteException;
import com.gugawag.mytwitter.armazenamento.UsuarioInexistenteException;
import com.gugawag.mytwitter.controle.ControladorMensagem;
import com.gugawag.mytwitter.controle.ControladorMensagemIF;
import com.gugawag.mytwitter.controle.ControladorUsuario;
import com.gugawag.mytwitter.controle.ControladorUsuarioIF;
import com.gugawag.mytwitter.controle.FachadaMyTwitterIF;
import com.gugawag.mytwitter.controle.UsuarioJahSeguidoException;
import com.gugawag.mytwitter.modelo.Mensagem;
import com.gugawag.mytwitter.modelo.Usuario;
import com.gugawag.mytwitter.modelo.UsuarioNaoSeguidoException;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FachadaMyTwitter
implements FachadaMyTwitterIF {
    private ControladorUsuarioIF controladorUsuario = new ControladorUsuario(new RepositorioArquivoUsuarios());
    private ControladorMensagemIF controladorMensagem = new ControladorMensagem();
    private static FachadaMyTwitterIF instance;

    public static FachadaMyTwitterIF getInstance() {
        if (instance == null) {
            instance = new FachadaMyTwitter();
        }
        return instance;
    }

    private FachadaMyTwitter() {
    }

    @Override
    public void inserirUsuario(Usuario usuario) throws UsuarioExistenteException {
        this.controladorUsuario.inserirUsuario(usuario);
    }

    @Override
    public void removerUsuario(String email) throws UsuarioInexistenteException {
        this.controladorUsuario.removerUsuario(email);
    }

    @Override
    public Map<String, Usuario> getUsuarios() {
        return this.controladorUsuario.getUsuarios();
    }

    @Override
    public Collection<Usuario> getUsuariosComoColecao() {
        return this.controladorUsuario.getUsuariosComoColecao();
    }

    @Override
    public Usuario getUsuarioPorEmail(String email) {
        return this.controladorUsuario.getUsuarioPorEmail(email);
    }

    @Override
    public void seguirUsuario(Usuario seguidor, Usuario seguido) throws UsuarioJahSeguidoException {
        this.controladorUsuario.seguirUsuario(seguidor, seguido);
    }

    @Override
    public void pararDeSeguirUsuario(Usuario seguidor, Usuario seguido) throws UsuarioNaoSeguidoException {
        this.controladorUsuario.pararDeSeguirUsuario(seguidor, seguido);
    }

    @Override
    public void enviarMensagem(Usuario enviador, Mensagem mensagem) {
        this.controladorUsuario.enviarMensagem(enviador, mensagem);
    }
}

