/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.gugawag.mytwitter.servlets;

import com.gugawag.mytwitter.armazenamento.RepositorioArquivoUsuarios;
import com.gugawag.mytwitter.modelo.Usuario;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 *
 * @author gugawag
 */
public class CadastrarServlet extends HttpServlet {
   
    /** 
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        String email = (String) request.getParameter("email");
        String senha = (String) request.getParameter("senha");
        String senhaRedigitada = (String) request.getParameter("senharedigitada");

        //Repositórios dos usuários twitteiros do sistema
        RepositorioArquivoUsuarios repUsuarios = (RepositorioArquivoUsuarios) getServletContext().getAttribute("repositorioUsuarios");

        boolean cadastroSucesso = true;

        //Tratamento de erros

        RequestDispatcher dispatcherSucesso = request.getRequestDispatcher("cadastrosucesso.jsp");
        RequestDispatcher dispatcherFracasso = request.getRequestDispatcher("cadastrofracasso.jsp");

        //usuário já existe e não deve ser cadastrado
        if (repUsuarios.getUsuarioPorEmail(email) != null){
            request.setAttribute("mensagemErro", "Usuário já havia sido cadastrado!");
            cadastroSucesso = false;
        }

        //Senhas diferem
        if (!senhaRedigitada.equals(senha)){
            request.setAttribute("mensagemErro", "Senhas não conferem!");
            cadastroSucesso = false;
        }

        if (cadastroSucesso){
            Usuario usuario = new Usuario(email, senha);
            repUsuarios.inserirUsuario(usuario);
            dispatcherSucesso.forward(request, response);
        } else{
            dispatcherFracasso.forward(request, response);
        }


    } 

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** 
     * Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    } 

    /** 
     * Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }

    /** 
     * Returns a short description of the servlet.
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "Short description";
    }// </editor-fold>

}
