/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.gugawag.mensagens.dados;

import com.gugawag.mensagens.modelo.Mensagem;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 *
 * @author profgustavo
 */
@Stateless(name="RepositorioMensagens")
public class RepositorioMensagens implements IRepositorioMensagens {

    @PersistenceContext(unitName="MensagensPU")
    private EntityManager em;

    public void inserirOuAtualizarMensagem(Mensagem mensagem){

        //se a mensagem já existe. Provavelmente uma atualização
        if (mensagem.getCodigo() != null){
            em.merge(mensagem);
            //else abaixo representa objeto novo
        } else{
            em.persist(mensagem);
        }
        
    }

    public List<Mensagem> getMensagens(){
        return em.createQuery("from Mensagem").getResultList();
    }




}
