package com.gugawag.tw.servlets;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.gugawag.tw.modelo.Carrinho;
import com.gugawag.tw.modelo.Produto;

public class InsereProdutoServlet extends HttpServlet {

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		int codigo = Integer.parseInt(request.getParameter("codigo") ); 
		List<Produto> produtos = (List<Produto>)getServletContext().getAttribute("produtos");
		
		//A posicao do produto na lista eh o numero do seu codigo -1
		Produto produtoAInserir = produtos.get(codigo - 1);
		
		HttpSession secao = request.getSession(true);
		Carrinho carrinho = null;
		if (!secao.isNew()){
			carrinho = (Carrinho)secao.getAttribute("carrinho");
		}
		
		//Nao havia ainda secao
		if (carrinho == null){
			carrinho = new Carrinho();
		}
		carrinho.insereProduto(produtoAInserir);
		secao.setAttribute("carrinho", carrinho);
		
		RequestDispatcher dispatcher = request.getRequestDispatcher("ListaCarrinho.do");
		dispatcher.forward(request, response);
	}
	
	
	

}
